/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.models.UnbakedGeometryHelper;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import io.github.fabricators_of_create.porting_lib.models.geometry.SimpleModelState;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_806;
import slimeknights.mantle.client.model.util.BakedItemModel;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.util.JsonHelper;

public class NBTKeyModel
implements IUnbakedGeometry<NBTKeyModel> {
    public static final Loader LOADER = new Loader();
    private static final class_801 ITEM_MODEL_GENERATOR = new class_801();
    private static final Multimap<class_2960, Pair<String, class_2960>> EXTRA_TEXTURES = HashMultimap.create();
    private final String nbtKey;
    @Nullable
    private final class_2960 extraTexturesKey;
    private Map<String, class_4730> textures = Collections.emptyMap();

    public static void registerExtraTexture(class_2960 key, String textureName, class_2960 texture) {
        EXTRA_TEXTURES.put((Object)key, (Object)Pair.of((Object)textureName, (Object)texture));
    }

    private static class_1087 bakeModel(class_793 owner, class_4730 texture, Function<class_4730, class_1058> spriteGetter, class_806 overrides) {
        class_1058 sprite = spriteGetter.apply(texture);
        List quads = UnbakedGeometryHelper.bakeElements((List)ITEM_MODEL_GENERATOR.method_3480(-1, sprite.method_45851().method_45816().toString(), sprite.method_45851()), spriteGetter, (class_3665)new SimpleModelState(class_4590.method_22931()), (class_2960)sprite.method_45851().method_45816());
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        for (class_777 quad2 : quads) {
            emitter.fromVanilla(quad2, RendererAccess.INSTANCE.getRenderer().materialFinder().find(), null);
            emitter.emit();
        }
        return new BakedItemModel(meshBuilder.build(), quad -> true, sprite, owner.method_3443(), overrides, true, owner.method_24298().method_24299());
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        this.textures = new HashMap<String, class_4730>();
        class_4730 defaultTexture = owner.method_24077("default");
        this.textures.put("default", defaultTexture);
        ModelTextureIteratable iterable = new ModelTextureIteratable(null, owner);
        for (Map map : iterable) {
            for (String key : map.keySet()) {
                if (this.textures.containsKey(key) || !owner.method_3432(key)) continue;
                this.textures.put(key, owner.method_24077(key));
            }
        }
        if (this.extraTexturesKey != null) {
            for (Pair extra : EXTRA_TEXTURES.get((Object)this.extraTexturesKey)) {
                String key = (String)extra.getFirst();
                if (this.textures.containsKey(key)) continue;
                this.textures.put(key, new class_4730(class_1059.field_5275, (class_2960)extra.getSecond()));
            }
        }
        ImmutableMap.Builder variants = ImmutableMap.builder();
        for (Map.Entry<String, class_4730> entry : this.textures.entrySet()) {
            String key;
            key = entry.getKey();
            if (key.equals("default")) continue;
            variants.put((Object)key, (Object)NBTKeyModel.bakeModel(owner, entry.getValue(), spriteGetter, class_806.field_4292));
        }
        return NBTKeyModel.bakeModel(owner, this.textures.get("default"), spriteGetter, new Overrides(this.nbtKey, this.textures, (Map<String, class_1087>)variants.build()));
    }

    public NBTKeyModel(String nbtKey, @Nullable class_2960 extraTexturesKey) {
        this.nbtKey = nbtKey;
        this.extraTexturesKey = extraTexturesKey;
    }

    public static class Overrides
    extends class_806 {
        private final String nbtKey;
        private final Map<String, class_4730> textures;
        private final Map<String, class_1087> variants;

        public class_1087 method_3495(class_1087 model, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 livingEntity, int pSeed) {
            class_2487 nbt = stack.method_7969();
            if (nbt != null && nbt.method_10545(this.nbtKey)) {
                return this.variants.getOrDefault(nbt.method_10558(this.nbtKey), model);
            }
            return model;
        }

        public class_4730 getTexture(String name) {
            class_4730 texture = this.textures.get(name);
            return texture != null ? texture : this.textures.get("default");
        }

        public Overrides(String nbtKey, Map<String, class_4730> textures, Map<String, class_1087> variants) {
            this.nbtKey = nbtKey;
            this.textures = textures;
            this.variants = variants;
        }
    }

    private static class Loader
    implements IGeometryLoader<NBTKeyModel> {
        private Loader() {
        }

        public NBTKeyModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            String key = class_3518.method_15265((JsonObject)modelContents, (String)"nbt_key");
            class_2960 extraTexturesKey = null;
            if (modelContents.has("extra_textures_key")) {
                extraTexturesKey = JsonHelper.getResourceLocation(modelContents, "extra_textures_key");
            }
            return new NBTKeyModel(key, extraTexturesKey);
        }
    }
}

